<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa icon-attendance"></i> <?= $this->lang->line('panel_title') ?></h3>

        <ol class="breadcrumb">
            <li><a href="<?= base_url("dashboard/index") ?>"><i class="fa fa-laptop"></i> <?= $this->lang->line('menu_dashboard') ?></a></li>
            <li class="active"><?= $this->lang->line('menu_add') ?> <?= $this->lang->line('menu_uattendance') ?></li>
        </ol>
    </div>

    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <form method="post" id="user_attendance">
                    <div class="row">
                        <div class="col-md-6 col-md-offset-3">
                            <div id="reader" width="600px"></div>
                        </div>
                        <div class="col-md-10 col-md-offset-1 text-center">
                            <div class="row">
                                <div class="col-md-4 col-md-offset-4">
                                <div id="validation_error" class="alert alert-danger" style="display: none;"></div>
                                
                                    <div class="<?php echo form_error('date') ? 'form-group has-error' : 'form-group'; ?>">
                                        <label for="usertype" class="control-label">
                                            User Type <span class="text-red">*</span>
                                            <!-- idcardreport_usertype -->
                                        </label>
                                        <?php
                                        $classArray = array(
                                            3 => "Student",
                                            2 => "Teacher",
                                            1 => "User"
                                        );

                                        echo form_dropdown("user_type", $classArray, array(), "id='usertype' class='form-control select2'");
                                        ?>

                                        <label for="roll_no" class="control-label" id="roll_no_label">
                                            Roll no. / ID
                                        </label>
                                        <div class="input-group">
                                            <input type="text" id="roll_no" class="form-control">
                                            <span class="input-group-btn">
                                                <button class="btn btn-default" id="verify_id">Verify</button>
                                            </span>
                                        </div><!-- /input-group -->

                                        <div class="box-layout" id="attendence_res" style="display: none;"></div>
                                        <div class="form-group" style="margin-top: 10px;">
                                            <button  id="clock_in" class="btn btn-primary">Clock-in</button>
                                            <button  id="clock_out" class="btn btn-primary">Clock-out</button>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="col-sm-4 col-sm-offset-4 box-layout-fame" id="attendence_res" style="display: none;"> -->
                                    
                                <!-- </div> -->
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<script>
    function isempty(n){
        return !(!!n ? typeof n === 'object' ? Array.isArray(n) ? !!n.length : !!Object.keys(n).length : true : false);
    }

    $(document).ready(function() {

        var d = new Date();

        change_label_based_on_user_type();

        $('#usertype').change(function () {
            change_label_based_on_user_type();
        });

        $('#verify_id').click(function(e) {
            e.preventDefault();
            $('#attendence_res').hide();
            var usertype = $('#usertype').val();
            var roll_no = $('#roll_no').val();

            if(isempty(roll_no)){
                $('#validation_error').show();
                $('#validation_error').html('<span>Please Enter Roll no / ID / Registration no</span>');
            } else{
                var day = d.getDate();
                $.ajax({
                    type: "post",
                    url: "<?= base_url('attendance/verify_attendence'); ?>",
                    data: {
                        'usertype' : usertype,
                        'roll_no'  : roll_no
                    },
                    dataType: "json",
                    success: function (response) {

                        if(response != 0){
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            "<tr><td colspan='2'>"+response.photo+"</td></tr>"+
                            "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                            "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                            "<tr><td><strong><h5>Clock-in:</h5></strong></td><td><h5>"+ ((response.clock_in) ? response.clock_in : '-')+"</h5></td></tr>"+
                            "<tr><td><strong><h5>Clock-out:</h5></strong></td><td><h5>"+ ((response.clock_out) ? response.clock_out : '-')+"</h5></td></tr>"+"</table>");
                        } else{
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            "<tr><th class='danger text-center' colspan='2'><span><strong>Not Found</strong><span></th></tr>"+
                            "</table>");
                        }
                        
                    }
                });
            }

        });

        $('#clock_in').click(function(e){
            e.preventDefault();
            var usertype = $('#usertype').val();
            var roll_no = $('#roll_no').val();
            $('#validation_error').hide();
            if(isempty(roll_no)){

                $('#validation_error').show();
                $('#validation_error').html('<span>Please Enter Roll no / ID</span>');
            } else{
                $.ajax({
                    type: "post",
                    url: "<?= base_url('attendance/clock_in'); ?>",
                    data: {
                        'usertype' : usertype,
                        'roll_no'  : roll_no
                    },
                    dataType: "json",
                    success: function (response) {

                        if(response.status){
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            "<tr><th class='danger text-center' colspan='2'><span><strong>"+response.message+"</strong><span></th></tr>"+
                            "</table>");
                        }else {
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            "<tr><td colspan='2'>"+response.photo+"</td></tr>"+
                            "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                            "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                            "<tr><td><strong><h5>Clock-in:</h5></strong></td><td><h5>"+((response.clock_in) ? response.clock_in : '-')+"</h5></td></tr>"+
                            "<tr><td><strong><h5>Clock-out:</h5></strong></td><td><h5>"+((response.clock_out) ? response.clock_out : '-')+"</h5></td></tr>"+"</table>");
                        }
                        
                    }
                });
            }

        });

        $('#clock_out').click(function(e){
            e.preventDefault();
            var usertype = $('#usertype').val();
            var roll_no = $('#roll_no').val();
            if(isempty(roll_no)){

                $('#validation_error').show();
                $('#validation_error').html('<span>Please Enter Roll no / ID</span>');
            } else{
                $.ajax({
                    type: "post",
                    url: "<?= base_url('attendance/clock_out'); ?>",
                    data: {
                        'usertype' : usertype,
                        'roll_no'  : roll_no
                    },
                    dataType: "json",
                    success: function (response) {

                        if(response.status){
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            ((response.photo) ? "<tr><td colspan='2'>"+response.photo+"</td></tr>":'')+
                            ((response.name) ? "<tr><td colspan='2'>"+response.name+"</td></tr>":'')+
                            ((response.user_type) ? "<tr><td colspan='2'>"+response.user_type+"</td></tr>":'')+
                            // "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                            // "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                            "<tr><th class='danger text-center' colspan='2'><span><strong>"+response.message+"</strong><span></th></tr>"+
                            "</table>");
                        } else {
                            $('#attendence_res').show();
                            $('#attendence_res').html("<table class='table table-responsive'>"+
                            "<tr><td colspan='2'>"+response.photo+"</td></tr>"+
                            "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                            "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                            "<tr><td><strong><h5>Clock-in:</h5></strong></td><td><h5>"+((response.clock_in) ? response.clock_in : '-')+"</h5></td></tr>"+
                            "<tr><td><strong><h5>Clock-out:</h5></strong></td><td><h5>"+((response.clock_out) ? response.clock_out : '-')+"</h5></td></tr>"+"</table>");
                        }
                        
                    }
                });
            }
        });
    });

    function change_label_based_on_user_type() {
        var label = $("#roll_no_label");

        if ($("#usertype").find('option:selected').val() == 3){ // If student
            label.text("Registration no. / ID")
        }else {
            label.text("Roll no. / ID")
        }
    }
</script>